/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import moe.plushie.armourers_workshop.api.ArmourersWorkshopApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.NPCRendererHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.client.layer.LayerArms;
import noppes.npcs.client.layer.LayerBody;
import noppes.npcs.client.layer.LayerCustomArmor;
import noppes.npcs.client.layer.LayerCustomHeldItem;
import noppes.npcs.client.layer.LayerCustomModels;
import noppes.npcs.client.layer.LayerEyes;
import noppes.npcs.client.layer.LayerHead;
import noppes.npcs.client.layer.LayerLegs;
import noppes.npcs.client.layer.LayerNpcCloak;
import noppes.npcs.client.layer.LayerPreRender;
import noppes.npcs.client.model.ModelNpcAlt;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class RenderCustomNpc<T extends EntityCustomNpc>
extends RenderNPCInterface<T> {
    private EntityLivingBase entity;
    public ModelBiped npcmodel;
    private float partialTicks;
    private RenderLivingBase<EntityLivingBase> renderEntity;

    public RenderCustomNpc(ModelBiped model) {
        super((ModelBase)model, 0.5f);
        this.npcmodel = (ModelBiped)this.field_77045_g;
        this.func_177094_a(new LayerEyes(this));
        this.func_177094_a(new LayerHead(this));
        this.func_177094_a(new LayerArms(this));
        this.func_177094_a(new LayerLegs(this));
        this.func_177094_a(new LayerBody(this));
        this.func_177094_a(new LayerNpcCloak(this));
        this.func_177094_a(new LayerCustomModels(this));
        this.func_177094_a((LayerRenderer)new LayerCustomHead(this.npcmodel.field_78116_c));
        this.func_177094_a(new LayerCustomHeldItem(this));
        boolean smallArmsIn = model instanceof ModelNpcAlt && ((ModelNpcAlt)model).smallArmsIn;
        boolean isClassicPlayer = model instanceof ModelNpcAlt && ((ModelNpcAlt)model).isClassicPlayer;
        this.func_177094_a((LayerRenderer)new LayerCustomArmor((RenderLivingBase<?>)this, false, smallArmsIn, isClassicPlayer));
    }

    @Override
    protected void applyRotations(@Nonnull T npc, float handleRotation, float rotationYaw, float partialTicks) {
        if (this.renderEntity != null && !(this.renderEntity instanceof RenderCustomNpc)) {
            NPCRendererHelper.applyRotations(this.renderEntity, this.entity, handleRotation, rotationYaw, partialTicks);
            return;
        }
        if (((EntityNPCInterface)((Object)npc)).func_70089_S()) {
            super.applyRotations(npc, handleRotation, rotationYaw, partialTicks);
            return;
        }
        GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (((EntityCustomNpc)((Object)npc)).field_70725_aQ > 0) {
            if (((EntityCustomNpc)((Object)npc)).animation.hasAnim(AnimationKind.DIES)) {
                if (!((EntityCustomNpc)((Object)npc)).animation.isAnimated(AnimationKind.DIES)) {
                    ((EntityCustomNpc)((Object)npc)).animation.tryRunAnimation(AnimationKind.DIES);
                }
                return;
            }
            float f = ((float)((EntityCustomNpc)((Object)npc)).field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)npc)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)((EntityNPCInterface)((Object)npc)).func_70005_c_());
            if ("Dinnerbone".equals(s) || "Grumm".equals(s)) {
                GlStateManager.func_179109_b((float)0.0f, (float)(((EntityCustomNpc)((Object)npc)).field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void doRender(@Nonnull T npc, double d, double d1, double d2, float f, float partialTicks) {
        this.partialTicks = partialTicks;
        this.entity = ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc));
        if (this.entity != null) {
            Render render = this.field_76990_c.func_78713_a((Entity)this.entity);
            if (render instanceof RenderLivingBase) {
                this.renderEntity = (RenderLivingBase)render;
            } else {
                this.renderEntity = null;
                this.entity = null;
            }
        } else {
            this.renderEntity = null;
            List list = this.field_177097_h;
            for (LayerRenderer layer : list) {
                if (!(layer instanceof LayerPreRender)) continue;
                ((LayerPreRender)layer).preRender((EntityCustomNpc)((Object)npc));
            }
        }
        this.npcmodel.field_187076_m = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).func_184614_ca());
        this.npcmodel.field_187075_l = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).func_184592_cb());
        super.doRender(npc, d, d1, d2, f, partialTicks);
    }

    public ModelBiped.ArmPose getPose(T npc, ItemStack item) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return ModelBiped.ArmPose.EMPTY;
        }
        if (npc.func_184605_cv() > 0) {
            EnumAction enumaction = item.func_77975_n();
            if (enumaction == EnumAction.BLOCK) {
                return ModelBiped.ArmPose.BLOCK;
            }
            if (enumaction == EnumAction.BOW) {
                return ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        }
        return ModelBiped.ArmPose.ITEM;
    }

    @Override
    protected float handleRotationFloat(@Nonnull T par1EntityLivingBase, float partialTicks) {
        if (this.renderEntity != null) {
            return NPCRendererHelper.handleRotationFloat(this.entity, partialTicks, this.renderEntity);
        }
        return super.handleRotationFloat(par1EntityLivingBase, partialTicks);
    }

    @Override
    protected void preRenderCallback(@Nonnull T npc, float f) {
        if (this.renderEntity != null) {
            this.renderColor((EntityNPCInterface)((Object)npc));
            int size = ((EntityCustomNpc)((Object)npc)).display.getSize();
            if (this.entity instanceof EntityNPCInterface) {
                ((EntityNPCInterface)this.entity).display.setSize(5);
            }
            NPCRendererHelper.preRenderCallback(this.entity, f, this.renderEntity);
            ((EntityCustomNpc)((Object)npc)).display.setSize(size);
            GlStateManager.func_179152_a((float)(0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize()), (float)(0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize()), (float)(0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize()));
        } else {
            super.preRenderCallback(npc, f);
        }
    }

    protected void renderLayers(@Nonnull T npc, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        if (this.entity != null && this.renderEntity != null) {
            NPCRendererHelper.drawLayers(this.entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn, this.renderEntity);
        } else {
            Map<EnumParts, Boolean> sp = ((EntityCustomNpc)((Object)npc)).animation.showParts;
            for (LayerRenderer layerrenderer : this.field_177097_h) {
                String layerName = layerrenderer.getClass().getSimpleName();
                if (((EntityCustomNpc)((Object)npc)).modelData.isDisableLayer(layerName) || (layerrenderer instanceof LayerEyes || layerrenderer instanceof LayerHead || layerName.equals("LayerCustomHead")) && !sp.get((Object)EnumParts.HEAD).booleanValue() || ArmourersWorkshopApi.isAvailable() && layerName.equals("LayerCustomHead") && ArmourersWorkshopApi.getSkinNBTUtils().hasSkinDescriptor(((EntityNPCInterface)((Object)npc)).func_184582_a(EntityEquipmentSlot.HEAD)) || (layerrenderer instanceof LayerBody || layerrenderer instanceof LayerNpcCloak) && !sp.get((Object)EnumParts.BODY).booleanValue() || layerName.equals("SkinLayerRendererCustomNPC")) continue;
                boolean flag = this.setBrightness(npc, partialTicks, layerrenderer.func_177142_b());
                layerrenderer.func_177141_a(npc, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn);
                if (!flag) continue;
                this.func_177091_f();
            }
        }
    }

    @Override
    protected void renderModel(@Nonnull T npc, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (this.renderEntity != null) {
            ModelBase pixModel;
            boolean isInvisible = ((EntityNPCInterface)((Object)npc)).func_82150_aj();
            if (((EntityCustomNpc)((Object)npc)).display.getVisible() == 1) {
                isInvisible = ((EntityCustomNpc)((Object)npc)).display.getAvailability().isAvailable((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            } else if (((EntityCustomNpc)((Object)npc)).display.getVisible() == 2) {
                boolean bl = isInvisible = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() != CustomRegisters.wand;
            }
            if (isInvisible) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            ModelBase model = this.renderEntity.func_177087_b();
            if (PixelmonHelper.isPixelmon((Entity)this.entity) && (pixModel = (ModelBase)PixelmonHelper.getModel(this.entity)) != null) {
                model = pixModel;
                PixelmonHelper.setupModel(this.entity, pixModel);
            }
            model.field_78095_p = this.field_77045_g.field_78095_p;
            model.field_78093_q = this.entity.func_184218_aH() && this.entity.func_184187_bx() != null && this.entity.func_184187_bx().shouldRiderSit();
            model.func_78086_a(this.entity, limbSwing, limbSwingAmount, this.partialTicks);
            model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, (Entity)this.entity);
            model.field_78091_s = this.entity.func_70631_g_();
            NPCRendererHelper.renderModel(this.entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, this.renderEntity, model, Objects.requireNonNull(this.getEntityTexture(npc)));
            if (!((EntityCustomNpc)((Object)npc)).display.getOverlayTexture().isEmpty()) {
                GlStateManager.func_179143_c((int)515);
                if (((EntityCustomNpc)((Object)npc)).textureGlowLocation == null) {
                    ((EntityCustomNpc)((Object)npc)).textureGlowLocation = new ResourceLocation(((EntityCustomNpc)((Object)npc)).display.getOverlayTexture());
                }
                float f1 = 1.0f;
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)1, (int)1);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((!((EntityNPCInterface)((Object)npc)).func_82150_aj() ? 1 : 0) != 0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)1.001f, (float)1.001f, (float)1.001f);
                NPCRendererHelper.renderModel(this.entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, this.renderEntity, model, ((EntityCustomNpc)((Object)npc)).textureGlowLocation);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179084_k();
            }
            if (isInvisible) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        } else {
            super.renderModel(npc, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        }
    }

    public void setLightmap(@Nonnull EntityCustomNpc npc) {
        super.func_177105_a((EntityLiving)npc);
    }

    public List<String> getLayerRendererNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("LayerWear");
        for (LayerRenderer layerrenderer : this.field_177097_h) {
            list.add(layerrenderer.getClass().getSimpleName());
        }
        return list;
    }
}

